/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
overall_score();

/**
 * Performs the overall score calculation for the specified models
 */
function getModifierValue(status, key) {
    const value = get_variable_value(status, key, "string");

    if (value == "Yes") {
        if (key.includes("CHEST_BELT_LOAD")) {
            return -40;
        } else if (key.includes("EXCEEDS_LOWER_LIMIT_FOR_TIBIA_INDEX_OR_TIBIA_FORCE")) {
            return -100;
        }
        return -20;
    }

    if (value == "No") {
        if (key.includes("EXCEEDS_LOWER_LIMIT_FOR_TIBIA_INDEX_OR_TIBIA_FORCE")) {
            return 100;
        }
        return 0;
    }

    if (value == "Off") {
        return 0;
    }
    return parseFloat(value); // fallback if it's actually a number in string form
}
function overall_score() {
    let templ = Template.GetCurrent();

    // let models = get_model_list();
    let models = ["M1", "T1"];

    let occupants = ["DRIVER", "FRONT_PASSENGER"];

    /* The following objects will be populated with values for each occupant */
    let head_neck_score = {};
    let head_neck_points = 0;
    let head_neck_score_pass = {};
    let head_neck_points_pass = {};
    let chest_abdomen_score = {};
    let chest_abdomen_points = {};
    let knee_femur_pelvis_score = {};
    let knee_femur_pelvis_points = {};
    let lower_leg_foot_ankle_score = {};
    let lower_leg_foot_ankle_points = {};
    let lower_leg_foot_ankle_points_true = {};
    let lower_leg_100 = 100;
    let lower_leg_mod;
    let occ_score = {};
    let occ_score_pass = {};
    let occ_capping_limit = {};

    let status = { success: true, missing: [], invalid: [] };
    let point_divisor = parseFloat(get_variable_value(status, "POINT_DIVISOR"));

    if (!point_divisor) {
        point_divisor = 1;
    }

    let total_possible = 0.625 / point_divisor;
    let brown = total_possible * 0.334;
    let orange = total_possible * 0.667;
    let yellow = total_possible * 0.999;

    let total_possible_sum = 2.5 / point_divisor;
    let brown_sum = total_possible_sum * 0.334;
    let orange_sum = total_possible_sum * 0.667;
    let yellow_sum = total_possible_sum * 0.999;

    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} overall score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Body region final scores */
            // head_neck_score[occ] = get_variable_value(status, `${m}_${occ}_HEAD_NECK_FINAL_SCORE`, "float");
            // head_neck_score_pass[occ] = get_variable_value(
            //     status,
            //     `${m}_${occ}_HEAD_NECK_FINAL_PASSENGER_SCORE`,
            //     "float"
            // );
            // chest_abdomen_score[occ] = get_variable_value(status, `${m}_${occ}_CHEST_ABDOMEN_FINAL_SCORE`, "float");
            // knee_femur_pelvis_score[occ] = get_variable_value(
            //     status,
            //     `${m}_${occ}_KNEE_FEMUR_PELVIS_FINAL_SCORE`,
            //     "float"
            // );
            // lower_leg_foot_ankle_score[occ] = get_variable_value(
            //     status,
            //     `${m}_${occ}_LOWER_LEG_FOOT_ANKLE_FINAL_SCORE`,
            //     "float"
            // );

            head_neck_score[occ] = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_HEAD_NECK_FINAL_SCORE`,
                "float",
                templ
            );
            head_neck_points = (head_neck_score[occ] * 0.00625) / point_divisor;
            head_neck_points = replaceNaNWithMissing(head_neck_points);

            head_neck_score_pass[occ] = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_HEAD_NECK_FINAL_PASSENGER_SCORE`,
                "float",
                templ
            );
            head_neck_points_pass = (head_neck_score_pass[occ] * 0.00625) / point_divisor;
            head_neck_points_pass = replaceNaNWithMissing(head_neck_points_pass);
            chest_abdomen_score[occ] = get_variable_value(status, `${m}_${occ}_CHEST_ABDOMEN_FINAL_SCORE`, "float");
            chest_abdomen_score[occ] = replaceNaNWithMissing(chest_abdomen_score[occ]);
            chest_abdomen_points[occ] = (chest_abdomen_score[occ] * 0.00625) / point_divisor;
            chest_abdomen_points[occ] = replaceNaNWithMissing(chest_abdomen_points[occ]);
            knee_femur_pelvis_score[occ] = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_KNEE_FEMUR_PELVIS_FINAL_SCORE`,
                "float",
                templ
            );
            knee_femur_pelvis_points[occ] = (knee_femur_pelvis_score[occ] * 0.00625) / point_divisor;
            knee_femur_pelvis_points[occ] = replaceNaNWithMissing(knee_femur_pelvis_points[occ]);
            lower_leg_foot_ankle_score[occ] = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_LOWER_LEG_FOOT_ANKLE_FINAL_SCORE`,
                "float",
                templ
            );
            lower_leg_mod = getModifierValue(status, `M1_EXCEEDS_LOWER_LIMIT_FOR_TIBIA_INDEX_OR_TIBIA_FORCE_MODIFIER`);
            templ;

            lower_leg_foot_ankle_points_true[occ] = (lower_leg_foot_ankle_score[occ] * 0.00625) / point_divisor;
            lower_leg_foot_ankle_points_true[occ] = replaceNaNWithMissing(lower_leg_foot_ankle_points_true[occ]);
            /* since the default value for a "Yes" for modifiers is -20 im turning this mod into a score (0.625/3) is the score for the lower legs. Now when
            This mod is selected it will subtract the entire score of lower legs. The base option will be that lower legs are awarded full points unless specified by this mod*/

            lower_leg_mod = lower_leg_mod * 0.03125;
            lower_leg_foot_ankle_points = 0.625 / point_divisor + lower_leg_mod;

            /* Body region capping limits */
            let head_neck_capping_limit = get_variable_value(status, `${m}_${occ}_HEAD_NECK_CAPPING_LIMIT`, "string");
            let chest_capping_limit = get_variable_value(status, `${m}_${occ}_CHEST_CAPPING_LIMIT`, "string");

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            occ_score[occ] = 0;
            occ_score_pass[occ] = 0;
            occ_capping_limit[occ] = "*";

            /* If we have all the required variables, calculate the final scores */
            if (true) {
                /* Overall occupant score is sum of body region scores. */
                /* The math for the occ scores is as follows: these are % out of 100. first take the avg of the percent. 
                then multiply by the posible possible score thus 2.5(possible score) 4(total body segements) so 2.5/4. then divide by 100 to go from percent to score. 
                then divide by 3 to take the avg of the scores. finally add the lower leg score
                (0.625/3)+lower leg mod for a pass fail score of lower leg */
                occ_score[occ] =
                    ((head_neck_score.DRIVER +
                        chest_abdomen_score.DRIVER +
                        knee_femur_pelvis_score.DRIVER +
                        lower_leg_foot_ankle_score.DRIVER) *
                        (2.5 / 4)) /
                    100 /
                    point_divisor;
                LogPrint(`${m} ${occ} overall score = ${occ_score[occ]}`);

                occ_score_pass[occ] =
                    ((head_neck_score_pass.FRONT_PASSENGER +
                        chest_abdomen_score.FRONT_PASSENGER +
                        knee_femur_pelvis_score.FRONT_PASSENGER +
                        lower_leg_foot_ankle_score.FRONT_PASSENGER) *
                        (2.5 / 4)) /
                    100 /
                    point_divisor;

                occ_score = replaceNaNWithMissing(occ_score);
                occ_score_pass = replaceNaNWithMissing(occ_score_pass);
                /* Only remove the overall occupant capping limit if none of the body region
                 * capping limits were exceeded. */
                if (head_neck_capping_limit == "" && chest_capping_limit == "") {
                    occ_capping_limit[occ] = "";
                    LogPrint(`Capping limit not applied to ${m} ${occ}.`);
                } else {
                    LogPrint(`Capping limit applied to ${m} ${occ}.`);
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} overall score calculation`);
            }

            // let overall_occ_score_var = new Variable(
            //     templ,
            //     `${m}_${occ}_OVERALL_SCORE`,
            //     `Overall ${occ} score`,
            //     occ_score[occ].toString(),
            //     "String",
            //     false,
            //     true
            // );
            // let overall_occ_score_pass_var = new Variable(
            //     templ,
            //     `${m}_${occ}_OVERALL_PASSENGER_SCORE`,
            //     `Overall Front Passenger score`,
            //     occ_score_pass[occ].toString(),
            //     "String",
            //     false,
            //     true
            // );
            let brown_var = new Variable(
                templ,
                `BROWN`,
                `Brown condtional format`,
                brown.toString(),
                "String",
                false,
                true
            );
            let orange_var = new Variable(
                templ,
                `ORANGE`,
                `Orange condtional format`,
                orange.toString(),
                "String",
                false,
                true
            );
            let yellow_var = new Variable(
                templ,
                `YELLOW`,
                `Yellow condtional format`,
                yellow.toString(),
                "String",
                false,
                true
            );
            new Variable(
                templ,
                `BROWN_SUM`,
                `Brown sum condtional format`,
                brown_sum.toString(),
                "String",
                false,
                true
            );
            new Variable(
                templ,
                `ORANGE_SUM`,
                `Orange sum condtional format`,
                orange_sum.toString(),
                "String",
                false,
                true
            );
            new Variable(
                templ,
                `YELLOW_SUM`,
                `Yellow sum condtional format`,
                yellow_sum.toString(),
                "String",
                false,
                true
            );

            let head_neck_points_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_NECK_POINTS`,
                `Final ${occ} Head and Neck Points`,
                head_neck_points.toString(),
                "String",
                false,
                true
            );
            let head_neck_points_pass_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_NECK_PASS_POINTS`,
                `Final ${occ} Head and Neck Points`,
                head_neck_points_pass.toString(),
                "String",
                false,
                true
            );
            let chest_abdomen_points_var = new Variable(
                templ,
                `${m}_${occ}_CHEST_POINTS`,
                `Final ${occ} Chest Points`,
                chest_abdomen_points[occ].toString(),
                "String",
                false,
                true
            );
            let knee_femur_pelvis_points_var = new Variable(
                templ,
                `${m}_${occ}_KNEE_FEMUR_PELVIS_POINTS`,
                `Final ${occ} Knee Femur Pelvis Points`,
                knee_femur_pelvis_points[occ].toString(),
                "String",
                false,
                true
            );
            let lower_leg_foot_ankle_points_var = new Variable(
                templ,
                `${m}_LOWER_LEGS_POINTS`,
                `Final Lower Leg Points`,
                lower_leg_foot_ankle_points.toString(),
                "String",
                false,
                true
            );
            let lower_leg_foot_ankle_var = new Variable(
                templ,
                `${m}_${occ}_LOWER_LEG_POINTS_TRUE`,
                `Final Lower Leg Points`,
                lower_leg_foot_ankle_points_true[occ].toString(),
                "String",
                false,
                true
            );

            let overall_occ_score_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_OVERALL_SCORE`,
                `Overall ${occ} score`,
                occ_score[occ].toString(),
                "String",
                false,
                true
            );
            let overall_occ_score_pass_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_OVERALL_PASSENGER_SCORE`,
                `Overall Front Passenger score`,
                occ_score_pass[occ].toString(),
                "String",
                false,
                true
            );
        }

        let overall_score = 0.0;

        /* Overall capping limit applied if either occupant's capping limit exceeded. 0.41667 is (0.625/3)*2 to account for EuroNCAP lowerleg score */

        overall_score =
            ((head_neck_score.DRIVER +
                chest_abdomen_score.DRIVER +
                knee_femur_pelvis_score.DRIVER +
                lower_leg_foot_ankle_score.DRIVER +
                head_neck_score_pass.FRONT_PASSENGER +
                chest_abdomen_score.FRONT_PASSENGER +
                knee_femur_pelvis_score.FRONT_PASSENGER +
                lower_leg_foot_ankle_score.FRONT_PASSENGER) *
                (5 / 8)) /
            100 /
            point_divisor;

        overall_score = replaceNaNWithMissing(overall_score);

        let overall_score_report = overall_score / 2;

        overall_score_report = replaceNaNWithMissing(overall_score_report);

        let overall_score_var = new_variable_and_new_euroNCAP_banded_score(
            templ,
            `${m}_OVERALL_SCORE`,
            `Overall score`,
            overall_score.toString(),
            "String",
            false,
            true
        );
        let overall_score_report_var = new_variable_and_new_euroNCAP_banded_score(
            templ,
            `${m}_OVERALL_REPORT_SCORE`,
            `Overall score per report`,
            overall_score_report.toString(),
            "String",
            false,
            true
        );
    }
}
// function euroNCAPBandScore(s) {
//     if (s <= 0) return "0%";
//     if (s <= 0.333) return "20%";
//     if (s <= 0.6667) return "40%";
//     if (s < 100) return "80%";

//     return "100%";
// }
